/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ///////////////////////////////////////////////////////////////////////// */

#include <stdio.h>
#include "get_time.h"

void
configure_timer(void)
{

    DSP_CNTL_TIMER3 = (0 << 6) |    // free run
        (1 << 5) |              // clock gating
        (0 << 2) |              // prescale
        (0 << 1) |              // one shot only
        (0 << 0);
    DSP_LOAD_TIMER3_HI = 0xFFFF;    //maxiam
    DSP_LOAD_TIMER3_LO = 0xFFFF;
    DSP_CNTL_TIMER3 |= 1;       //start timer3
}

unsigned long
read_counter(void)
{
    unsigned long count = 0;
    unsigned long temp;
    temp = (unsigned long) DSP_READ_TIMER3_HI;
    //count=((long)DSP_READ_TIMER3_HI)<<16;//To read correct value for DSP 32-bit OS timer, this register must be read first,                                                           //followed by lower 16 bits of DSP_READ_TIMER_LO.
    count = _lshl(temp, 16), count = count | DSP_READ_TIMER3_LO;
    return count;
}

struct ts t;

void
init_timer()
{
    t.idct = t.iquant = t.conv = t.edges =
        t.trans = t.coding = t.comp = t.prediction =
        t.global = t.overall = t.dma_out = t.bitstreamtime = t.get_mv_time =
        t.copy_bitstrem_in = t.dma_in = t.dma_in_1 = t.dma_in_2 = t.dma_in_3 =
        t.dma_in_4 = t.dma_in_5 = t.dma_in_6 = t.dma_in_7 = t.dma_in_8 =
        t.dma_in_9 = t.decode_mbinter_time = 0;
}

void
start_timer()
{
    t.current = read_counter();
}

void
start_global_timer()
{
    t.global = read_counter();
}

void
stop_idct_timer()
{
    t.idct += (read_counter() - t.current);
}

void
stop_get_mv_timer()
{
    t.get_mv_time += (read_counter() - t.current);
}

void
stop_iquant_timer()
{
    t.iquant += (read_counter() - t.current);
}

void
stop_copybistream_timer()
{
    t.copy_bitstrem_in += (read_counter() - t.current);
}

void
stop_comp_timer()
{
    t.comp += (read_counter() - t.current);
}

void
stop_edges_timer()
{
    t.edges += (read_counter() - t.current);
}

void
stop_conv_timer()
{
    t.conv += (read_counter() - t.current);
}

void
stop_transfer_timer()
{
    t.trans += (read_counter() - t.current);
}

void
stop_prediction_timer()
{
    t.prediction += (read_counter() - t.current);
}

void
stop_coding_timer()
{
    t.coding += (read_counter() - t.current);
}

void
stop_bitstreamreadheaders_timer()
{
    t.bitstreamtime += (read_counter() - t.current);
}

void
stop_dma_out()
{
    t.dma_out += (read_counter() - t.current);
}

void
stop_dma_in()
{
    t.dma_in += (read_counter() - t.current);
}

void
stop_dma_in_1()
{
    t.dma_in_1 += (read_counter() - t.current);
}

void
stop_dma_in_2()
{
    t.dma_in_2 += (read_counter() - t.current);
}

void
stop_dma_in_3()
{
    t.dma_in_3 += (read_counter() - t.current);
}

void
stop_dma_in_4()
{
    t.dma_in_4 += (read_counter() - t.current);
}

void
stop_dma_in_5()
{
    t.dma_in_5 += (read_counter() - t.current);
}

void
stop_dma_in_6()
{
    t.dma_in_6 += (read_counter() - t.current);
}

void
stop_dma_in_7()
{
    t.dma_in_7 += (read_counter() - t.current);
}

void
stop_dma_in_8()
{
    t.dma_in_8 += (read_counter() - t.current);
}

void
stop_dma_in_9()
{
    t.dma_in_9 += (read_counter() - t.current);
}

void
stop_global_timer()
{
    t.overall += (read_counter() - t.global);
}

void
stop_decode_mbinter_time()
{
    t.decode_mbinter_time += (read_counter() - t.current);
}
